package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.AppointmentReminderCronLogDTO;
import gov.va.med.mhv.calendar.model.AppointmentReminderCronLog;
import org.springframework.core.convert.converter.Converter;

public class AppointmentReminderCronLogConverter implements Converter<AppointmentReminderCronLog, AppointmentReminderCronLogDTO> {

	@Override
	public AppointmentReminderCronLogDTO convert(AppointmentReminderCronLog source) {
		AppointmentReminderCronLogDTO target = new AppointmentReminderCronLogDTO();
		
		target.setId(source.getId());
		target.setDateTimeRun(source.getDateTimeRun());
		
		return target;
	}
	
	public AppointmentReminderCronLog convert(AppointmentReminderCronLogDTO source) {
		AppointmentReminderCronLog target = new AppointmentReminderCronLog();
		
		target.setId(source.getId());
		target.setDateTimeRun(source.getDateTimeRun());
		
		return target;
	}
	public List<AppointmentReminderCronLogDTO> convert(List<AppointmentReminderCronLog> source) {
		List <AppointmentReminderCronLogDTO> appointmentReminderCronLogDto= null;
		if(null !=source) {
			appointmentReminderCronLogDto = new ArrayList<AppointmentReminderCronLogDTO>();

			for (AppointmentReminderCronLog appointmentReminderCronLog: source) {
				appointmentReminderCronLogDto.add(this.convert(appointmentReminderCronLog));
			}

		}

		return appointmentReminderCronLogDto;
	}

}
